/*
 * Settings.h
 *
 *  Created on: 30.10.2009
 *      Author: stefan.detter
 */

#ifndef SETTINGS_H_
#define SETTINGS_H_

#include <QObject>

class QSettings;

class Settings : public QObject
{
	Q_OBJECT

	Settings();
public:
	virtual ~Settings();

	void 	readSettings();
	void 	storeSettings();

public:
	uint 	refreshRate() const;

	bool 	attachReaderAutomatically() const;

	bool	multiplexOn() const;
	uint 	multiplexTime() const;

    bool    parseTagIds() const;
    bool    showTagIdAscii() const;

	bool 	ttlOn() const;
	uint	ttlInactive() const;
	uint	ttlOutOfRange() const;
	uint 	ttlDelete() const;

	bool	readBeepOn() const;
	uint 	readBeepType() const;
	uint 	readBeepParallel() const;

	bool	traceOn() const;
	int		traceLevel() const;

public:
	void 	setRefreshRate(uint rate);

	void 	setAttachReaderAutomatically(bool on);

	void	setMultiplexOn(bool on);
	void 	setMultiplexTime(uint time);

    void    setParseTagIds(bool parseTagIds);
    void    setShowTagIdAscii(bool asciiTagIds);

    void 	setTtlOn(bool on);
	void	setTtlInactive(uint time);
	void	setTtlOutOfRange(uint time);
	void 	setTtlDelete(uint time);

	void 	setReadBeep(bool on);
	void 	setReadBeepType(uint type);
	void 	setReadBeepParallel(uint type);

	void	setTraceOn(bool on);
	void	setTraceLevel(int level);

	static Settings* d;

signals:
    void 	automaticallyAttachChanged ( bool on );
    void 	readBeepChanged ( bool on );


private:
	static Settings m_instance;

	QSettings* m_settings;

	uint 	m_refreshRate;

	bool 	m_attachReaderAutomatically;

	bool	m_multiplexOn;
	uint	m_multiplexTime;

    bool    m_parseTagIds;
    bool    m_asciiTagIds;

	bool 	m_ttlOn;
	uint	m_ttlInactive;
	uint	m_ttlOutOfRange;
	uint 	m_ttlDelete;

	bool 	m_readBeep;
	uint 	m_readBeepType;
	uint 	m_readBeepParallel;

	bool	m_traceOn;
	int 	m_traceLevel;
};

#endif /* SETTINGS_H_ */
